﻿using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;
using System.ComponentModel;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class StylishForm : Form 
    {
        Color titleBackgroundColor1 = Color.LightBlue;
        Color titleBackgroundColor2 = Color.Blue;
        Color titleForeColor = Color.WhiteSmoke;
        Brush titleForeColorBrush;
        string title_;

        public StylishForm() 
        {
            InitializeComponent();
            this.Icon = Resources.mainIco;
            this.DialogResult = DialogResult.Cancel;
            this.titleForeColorBrush = new SolidBrush(this.titleForeColor);
            this.Move += (sender, e) => ((Control)sender).Refresh();
        }

        [Category("表示"),
        Description("タイトルバーの背景色")]
        public Color TitleBackgroundColor1 
        {
            set {
                this.titleBackgroundColor1 = value;
                this.titleLbl.Refresh();
            }
            get {
                return this.titleBackgroundColor1;
            }
        }

        [Category("表示"),
        Description("タイトルバーの背景色")]
        public Color TitleBackgroundColor2 
        {
            set {
                this.titleBackgroundColor2 = value;
                this.titleLbl.Refresh();
            }
            get {
                return this.titleBackgroundColor2;
            }
        }

        [Category("表示"),
        Description("タイトルバーの文字色")]
        public Color TitleForeColor 
        {
            set {
                this.titleForeColorBrush.Dispose();
                this.titleForeColor = value;
                this.titleForeColorBrush = new SolidBrush(this.titleForeColor);
                this.titleLbl.Refresh();
            }
            get {
                return this.titleForeColor;
            }
        }

        [Category("表示"),
        Description("タイトルバーの文字")]
        public string TitleText
        {
            set
            {
                title_ = value;
                titleLbl.Refresh();
            }
            get
            {
                return title_;
            }
        }

        protected override void OnTextChanged(System.EventArgs e) {
            this.titleLbl.Refresh();
            base.OnTextChanged(e);
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Rectangle rect = new Rectangle(0, this.titleLbl.Height, this.Width - 1, this.Height - this.titleLbl.Height - 1);
            e.Graphics.DrawRectangle(Pens.Gray, rect);
            base.OnPaint(e);
        }

        private void titleLbl_Paint(object sender, PaintEventArgs e) 
        {
            var sender2 = (Label)sender;
            using (LinearGradientBrush g = new LinearGradientBrush(sender2.Bounds, this.titleBackgroundColor1, this.titleBackgroundColor2, LinearGradientMode.Vertical)) 
            {
                e.Graphics.FillRectangle(g, sender2.Bounds);
                StringFormat sf = new StringFormat();
                sf.Alignment = StringAlignment.Center;
                sf.LineAlignment = StringAlignment.Center;
                e.Graphics.DrawString(this.TitleText, sender2.Font, this.titleForeColorBrush, sender2.Bounds, sf);
                sf.Dispose();
            }
        }

        #region http://dobon.net/vb/dotnet/form/moveform.html より
        private Point mousePoint;

        private void titleLbl_MouseDown(object sender, MouseEventArgs e) {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left) {
                //位置を記憶する
                mousePoint = new Point(e.X, e.Y);
            }
        }

        private void titleLbl_MouseMove(object sender, MouseEventArgs e) {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left) {
                this.Left += e.X - mousePoint.X;
                this.Top += e.Y - mousePoint.Y;
            }
        }
        #endregion
    }
}
